package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.BgmiWinnerAdapter;
import app.firezone.synk.network.Adapter.TopWinnerAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityClaasicWinnerBinding;
import app.firezone.synk.network.model.Winner_Model;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;

public class ClaasicWinnerActivity extends AppCompatActivity {


    ActivityClaasicWinnerBinding binding;

    BgmiWinnerAdapter winnerAdapter;

    TopWinnerAdapter myAdapter;

    ArrayList<Winner_Model> topWinnerModels = new ArrayList<>();


    FirebaseDatabase database;

    String gameName, matchId;

    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityClaasicWinnerBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());


        binding.backArrow.setOnClickListener(v -> finish());

        database = FirebaseDatabase.getInstance();

        topWinnerModels = new ArrayList<Winner_Model>();

        matchId = getIntent().getStringExtra("matchid");
        gameName = getIntent().getStringExtra("gamename");

        String date = getIntent().getStringExtra("date");
        String time = getIntent().getStringExtra("time");
        String matchno = getIntent().getStringExtra("matchno");
        String images = getIntent().getStringExtra("images");

        Picasso.get().
                load(images)
                .placeholder(R.drawable.loading_img)
                .into(binding.imageView5);

        binding.dateTxt.setText(date);
        binding.timeTxt.setText(time);
        binding.gameName.setText(gameName + " " + matchno);


        dialog = new Dialog(this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() != null) {

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();


        LinearLayoutManager layoutManager2 = new LinearLayoutManager(ClaasicWinnerActivity.this);
        binding.topWinersRecy.setLayoutManager(layoutManager2);
        myAdapter = new TopWinnerAdapter(topWinnerModels, ClaasicWinnerActivity.this);
        binding.topWinersRecy.setAdapter(myAdapter);

        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        myApi.fetchResultMatchUserData(Long.parseLong(matchId)).enqueue(new Callback<ArrayList<Winner_Model>>() {
            @Override
            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    topWinnerModels.clear();

                    // Filter players with playerStatus = "Winner"
                    for (Winner_Model winner : response.body()) {
                        if ("Winner".equalsIgnoreCase(winner.getPlayerStatus())) {
                            topWinnerModels.add(winner);
                        }
                    }

                    if (topWinnerModels.isEmpty()) {
                        Toast.makeText(ClaasicWinnerActivity.this, "No winners found", Toast.LENGTH_SHORT).show();
                    }

                    myAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText(ClaasicWinnerActivity.this, "No winners found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(ClaasicWinnerActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
}